<?php
/**
 * Install File
 * Does the stuff for the specific extensions
 *
 * @package         Tabs
 * @version         3.1.3
 *
 * @author          Peter van Westen <peter@nonumber.nl>
 * @link            http://www.nonumber.nl
 * @copyright       Copyright © 2012 NoNumber All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

function install(&$states, &$ext)
{
	$name = 'Tabs';
	$alias = 'tabs';
	$ext = $name . ' (editor button & system plugin)';

	// SYSTEM PLUGIN
	$states[] = installExtension($states, $alias, 'System - ' . $name, 'plugin');

	// EDITOR BUTTON PLUGIN
	$states[] = installExtension($states, $alias, 'Editor Button - ' . $name, 'plugin', array('folder' => 'editors-xtd'));
}

// Stuff to do before installation / update
function beforeInstall(&$db)
{
	// rename tabber to tabs
	if (is_dir(JPATH_PLUGINS . '/system/tabber')) {
		$query = "UPDATE `#__extensions`
			SET	`name` = replace(`name`, " . $db->quote('TABBER') . "," . $db->quote('TABS') . "),
			`element` = " . $db->quote('tabs') . ",
			`manifest_cache` = replace(`manifest_cache`, " . $db->quote('TABBER') . "," . $db->quote('TABS') . "),
			`params` = replace(replace(replace(`params`,
				" . $db->quote('tabber_') . ", " . $db->quote('') . "),
				" . $db->quote('tag_tablink') . ", " . $db->quote('tag_link') . "),
				" . $db->quote('tablinkscroll') . ", " . $db->quote('linkscroll') . ")
			WHERE `element` = " . $db->quote('tabber');
		$db->setQuery($query);
		$db->execute();

		if (is_dir(JPATH_PLUGINS . '/system/tabs')) {
			$f = JPATH_PLUGINS . '/system/tabber';
			if (JFolder::exists($f)) {
				JFolder::delete($f);
			}
			$f = JPATH_PLUGINS . '/editors-xtd/tabber';
			if (JFolder::exists($f)) {
				JFolder::delete($f);
			}
			$f = JPATH_SITE . '/media/tabber';
			if (JFolder::exists($f)) {
				JFolder::delete($f);
			}

			// Delete plugin language files
			$lang_folder = JPATH_ADMINISTRATOR . '/language';
			$languages = JFolder::folders($lang_folder);
			$files = array('plg_editors-xtd_tabber', 'plg_system_tabber');
			foreach ($languages as $lang) {
				foreach ($files as $file) {
					$f = $lang_folder . '/' . $lang . '/' . $lang . '.' . $file . '.ini';
					if (JFile::exists($f)) {
						JFile::delete($f);
					}
					$f = $lang_folder . '/' . $lang . '/' . $lang . '.' . $file . '.sys.ini';
					if (JFile::exists($f)) {
						JFile::delete($f);
					}
				}
			}
		} else {
			JFolder::move('tabber', 'tabs', JPATH_PLUGINS . '/editors-xtd');
			JFolder::move('tabber', 'tabs', JPATH_PLUGINS . '/system');
			JFolder::move('tabber', 'tabs', JPATH_SITE . '/media');

			JFile::move('tabber.php', 'tabs.php', JPATH_PLUGINS . '/editors-xtd/tabs');
			JFile::move('tabber.xml', 'tabs.xml', JPATH_PLUGINS . '/editors-xtd/tabs');
			JFile::move('tabber.php', 'tabs.php', JPATH_PLUGINS . '/system/tabs');
			JFile::move('tabber.xml', 'tabs.xml', JPATH_PLUGINS . '/system/tabs');

			// Delete plugin language files
			$lang_folder = JPATH_ADMINISTRATOR . '/language';
			$languages = JFolder::folders($lang_folder);
			foreach ($languages as $lang) {
				JFile::move($lang_folder . '/' . $lang . '/' . $lang . '.plg_editors-xtd_tabber.ini', $lang_folder . '/' . $lang . '/' . $lang . '.plg_editors-xtd_tabs.ini');
				JFile::move($lang_folder . '/' . $lang . '/' . $lang . '.plg_editors-xtd_tabber.sys.ini', $lang_folder . '/' . $lang . '/' . $lang . '.plg_editors-xtd_tabs.sys.ini');
				JFile::move($lang_folder . '/' . $lang . '/' . $lang . '.plg_system_tabber.ini', $lang_folder . '/' . $lang . '/' . $lang . '.plg_system_tabs.ini');
				JFile::move($lang_folder . '/' . $lang . '/' . $lang . '.plg_system_tabber.sys.ini', $lang_folder . '/' . $lang . '/' . $lang . '.plg_system_tabs.sys.ini');
			}
		}
	}
}

// Stuff to do after installation / update
function afterInstall(&$db)
{
	// disable possible remaining old tabber plugins
	$query = "UPDATE `#__extensions`
		SET	`enabled` = 0
		WHERE `element` = " . $db->quote('tabber');
	$db->setQuery($query);
	$db->execute();
}
